//
// (c) 2021 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.12
import QtQuick.Layouts 1.12

import wesual.Create 1.0
import wesual.Ui     1.0

import wesual.data.Core 1.0

ColumnLayout {
    id : view

    property bool supportsContextMenu : true

    property alias document : dependencies.document
    property alias direction : dependencies.direction

    readonly property int totalCount :
        mediaFilter.result.length +
        areaFilter.result.length +
        groupFilter.result.length +
        spreadSheetFilter.result.length +
        eslFilter.result.length +
        dataFilter.filtered.length

    signal selectDocument(Document doc)
    signal editDocument(Document doc)
    signal removeDocument(Document doc)

    visible : totalCount > 0
    enabled : totalCount > 0
    spacing : 0

    DocumentDependencies {
        id : dependencies
    }

    DocumentFilter {
        id : mediaFilter

        documents : dependencies.result

        TypeFilterCriterion {
            types : [ "asset:image", "asset:pdf", "asset:video" ]
        }
    }

    DocumentFilter {
        id : areaFilter

        documents : dependencies.result

        TypeFilterCriterion {
            types : "area"
        }
    }

    DocumentFilter {
        id : groupFilter

        documents : dependencies.result

        TypeFilterCriterion {
            types : "areagroup"
        }
    }

    DocumentFilter {
        id : spreadSheetFilter

        documents : dependencies.result

        TypeFilterCriterion {
            types : "spreadsheet"
        }
    }

    DocumentFilter {
        id : eslFilter

        documents : dependencies.result

        TypeFilterCriterion {
            types : "epaperdevice"
        }
    }

    DocumentFilter {
        id : dataFilter

        documents : dependencies.result

        TypeFilterCriterion {
            types : [
                "area", "areagroup", "areafolder", "asset", "blueprint",
                "schema", "template", "mediaassetfolder",  "spreadsheet",
                "spreadsheetfolder", "epaperdevice"
            ]
            matchSubtypes : true
        }
    }

    // This ensures epapers get listed even without visiting the editor
    PersistentTypeListing {
        context : Creator.context
        type : "epaperdevice"
    }

    UiText {
        text : dependencies.direction === DocumentDependencies.Incoming ?
                qsTrId("ccf868b928db1e3d", totalCount) :
                qsTrId("fcd938607391323c", totalCount)

        Layout.fillWidth : true
    }

    Column {
        id : drawers

        spacing : -10

        Layout.fillWidth : true

        UiDrawer {
            collapsed : true
            label : qsTrId("f415e4a7f006b0b6").arg(
                        mediaFilter.result.length)

            visible : mediaFilter.result.length > 0
            enabled : mediaFilter.result.length > 0

            anchors {
                left : drawers.left
                right : drawers.right
            }

            Flow {
                spacing : 2

                Repeater {
                    model : mediaFilter.result
                    delegate : MediaDependencyDelegate {
                        asset : modelData

                        supportsContextMenu : view.supportsContextMenu

                        onRequestSelect : selectDocument(asset)
                    }
                }
            }
        }

        UiDrawer {
            collapsed : true
            label : qsTrId("3a4a6ae86500f03e").arg(
                        areaFilter.result.length);

            visible : areaFilter.result.length > 0
            enabled : areaFilter.result.length > 0

            anchors {
                left : drawers.left
                right : drawers.right
            }

            Flow {
                spacing : 2

                Repeater {
                    model : areaFilter.result
                    delegate : AreaDependencyDelegate {
                        area : modelData

                        supportsContextMenu : view.supportsContextMenu

                        onRequestSelect : selectDocument(area)
                        onRequestEdit : editDocument(area)
                    }
                }
            }
        }

        UiDrawer {
            collapsed : true
            label : qsTrId("a66e57cacd41c66b")  +
                    " (" + spreadSheetFilter.result.length + ")"

            visible : spreadSheetFilter.result.length > 0
            enabled : spreadSheetFilter.result.length > 0

            anchors {
                left : drawers.left
                right : drawers.right
            }

            Column {
                id : spreadSheetList

                Repeater {
                    model : spreadSheetFilter.result
                    delegate : SpreadSheetDependencyDelegate {
                        anchors {
                            left : spreadSheetList.left
                            right : spreadSheetList.right
                        }

                        spreadSheet : modelData

                        supportsContextMenu : view.supportsContextMenu

                        onRequestSelect : selectDocument(spreadSheet)
                        onRequestEdit : editDocument(spreadSheet)
                    }
                }
            }
        }

        UiDrawer {
            collapsed : true
            label : qsTrId("450cd8e2a5953333").arg(
                        groupFilter.result.length)

            visible : groupFilter.result.length > 0
            enabled : groupFilter.result.length > 0

            anchors {
                left : drawers.left
                right : drawers.right
            }

            Column {
                id : groupList

                Repeater {
                    model : groupFilter.result
                    delegate : AreaGroupDependencyDelegate {
                        anchors {
                            left : groupList.left
                            right : groupList.right
                        }

                        group : modelData

                        supportsContextMenu : view.supportsContextMenu

                        onRequestSelect : view.selectDocument(areaGroup)
                        onRequestRemove : view.removeDocument(areaGroup)
                    }
                }
            }
        }

        UiDrawer {
            collapsed : true
            label : qsTrId("96a2afcf0095ef59") + " (%1)".arg(
                        eslFilter.result.length)

            visible : eslFilter.result.length > 0
            enabled : eslFilter.result.length > 0

            anchors {
                left : drawers.left
                right : drawers.right
            }

            Column {
                id : eslList

                Repeater {
                    model : eslFilter.result
                    delegate : MouseArea {
                        id : eslDelegate

                        anchors {
                            left : eslList.left
                            right : eslList.right
                        }
                        implicitHeight : 26

                        UiText {
                            anchors.fill : eslDelegate
                            text : modelData.label
                            padding : 2
                        }
                    }
                }
            }
        }

        UiDrawer {
            collapsed : true
            enabled : dataFilter.filtered.length > 0
            label : qsTrId("eb782a79fd88ce92").arg(
                        dataFilter.filtered.length)

            visible : dataFilter.filtered.length > 0

            anchors {
                left : drawers.left
                right : drawers.right
            }

            Column {
                id : dataList

                Repeater {
                    model : dataFilter.filtered
                    delegate : MouseArea {
                        id : dataDelegate

                        anchors {
                            left : dataList.left
                            right : dataList.right
                        }
                        implicitHeight : 26

                        UiText {
                            anchors.fill : dataDelegate
                            text : modelData.label
                            padding : 2
                        }
                    }
                }
            }
        }
    }
}
